import numpy as np
import torch

def set_seed(seed, device):
    np.random.seed(seed)
    torch.manual_seed(seed)
    if device.type == 'cuda':
        torch.cuda.manual_seed_all(seed)
        torch.backends.cudnn.deterministic = True
        torch.backends.cudnn.benchmark = True

# Modifies stats in place
def dict_agg(stats, key, value, op='concat'):
    
    if 'instab' in key:
        if 'train' in key:
            value = np.repeat(value, 1000)
        else:
            value = np.repeat(value, 100)
    if key in stats.keys(): # and 'instab' not in key:
        if op == 'sum':
            stats[key] += value
        elif op == 'concat':
            stats[key] = np.concatenate((stats[key], value), axis=0)
        else:
            raise NotImplementedError
    else:
        stats[key] = value

def str_to_bool(value):
    if isinstance(value, bool):
        return value
    if value.lower() in {'false', 'f', '0', 'no', 'n'}:
        return False
    elif value.lower() in {'true', 't', '1', 'yes', 'y'}:
        return True
    raise ValueError('{value} is not a valid boolean value')
